﻿var projects = {
    initializeTreeView: function () {
        this.treeview = $(".h-projectFolders", this.context).a4listview({
            ajaxAction: a4.getAction("GetProjectFolders", "Monitoring", "Project"),
            stateKey: "Projects",
            icons: {
                Node: null
            },
            allowNodeMultiHighlight: true,
            selectNode: function (event, data) {
                sessions.datatable.a4datatable("option", "ajaxParams", { "projectIds": getSelectedNodes() });
                sessions.datatable.a4datatable("refresh", true);
            },            
            localizableTexts: { "Search": resources.SearchProjects }
        });
    }
}

var sessions = {
    context: $(".v-sessions"),
    datatable: null,
    initializeDataTable: function () {
        this.datatable = $(".h-sessionsTable", this.context).a4datatable({            
            ajaxAction: a4.getAction("GetSessions", "Monitoring", "Project"),
            advancedFilter: true,
            stateKey: "MonitoringActiveSessions",
            autoUpdate: true,
            columns: [
                { "Data": "UserName", "Title": resources.UserName, "HideInSelector": true },
                { "Data": "InterviewerName", "Title": resources.Interviewer },
                { "Data": "ProjectName", "Title": resources.Module, "HideInSelector": true },
                { "Data": "CreatedOn", "Title": resources.SessionStartAt, "Type": "datetime", "DefaultValue": resources.NotAvailable },
                { "Data": "InInterview", "Name": "InInterview", "Title": resources.InInterview, "Type": "boolean", "ShowIcon": true},
                { "Data": "InterviewStartedOn", "Type": "datetime", "Title": resources.InterviewStartAt, "DefaultValue": resources.NotAvailable },
                { "Data": "CurrentQuestionName", "Title": resources.CurrentQuestion },
                { "Data": "CurrentRecord", "Title": resources.CurrentRecord },
                { "Data": "ProntoServerId", "Title": resources.ProntoServer },
                { "Data": "MonitoringIp", "Title": resources.IpAddress},
                { "Data": "MonitoringPort", "Title": resources.Port },
                { "Data": "MSIStation", "Title": resources.MSILine },
                { "Data": "MonitoringActive", "Title": resources.Active, "Type": "boolean", "ShowIcon": true }                
            ],
            contextMenuItems: sessions.GetContextMenuItems(),
            contextMenuClick: function (event, data) {
                var row = data.row;
                var action = data.action;

                switch (action) {
                    case "join":
                    case "whisper":
                    case "listen":
                    case "view":
                        sessions.clickMonitoring(row, action);
                        break;
                }
            },
            localizableTexts: { "Search": resources.SearchSessions }
        });
    },
    bindEvents: function () {
        sessions.context.on("click", ".h-recordedSessions", function () {
            window.location.href = a4.getAction("RecordedSessions", "Monitoring", "Project");
        });
    },

    GetContextMenuItems: function () {

        var contextItem = [
            {
                "Action": "view", "Label": resources.View
            },
            {
                "Action": "listen", "Label": resources.Monitor,"DisplayCondition":
                function (data) {
                    return data.ProntoServerId != '0';
                }
            },

          
            {
                "Action": "whisper", "Label": resources.Whisper, "DisplayCondition":
                    function (data)
                    {
                        return data.ProntoServerId != '0' && data.TelephonyProviderType == "voip";
                    }
            },
            {
                "Action": "join", "Label": resources.Join, "DisplayCondition": function (data)
                {
                    return data.ProntoServerId != '0' && data.TelephonyProviderType == "voip";
                }
            }
        ];
        return contextItem;
    },

    clickMonitoring: function (row, action) {
        var data = "AgentUserID=" + row.UserId;
        data += "&ProntoID=" + row.ProntoServerId;
        data += "&ProjectID=" + row.ProjectId;

        AudioMonitoring._debug("monitor button click detected ... The supervisor id " + row.UserId + "click on " + action );
        AudioMonitoring.CollectMonitoringParameters(row.MonitoringUrl, data, true);
        AudioMonitoring.init(row.MonitoringUrl, action);
        AudioMonitoring.Login(action);
    }
}

$(document).ready(function () {
    var ajaxController = a4.getAction("", "Monitoring", "Project");

    setDialogResources();

    if (sessions.context.length > 0) {
        sessions.initializeDataTable();
        projects.initializeTreeView();
        sessions.bindEvents();

        Dialog.init(document, { confirmationTitle: "Title", alertTitle: "Title" });

        AudioMonitoring._debug("Creating session with page controler: " + ajaxController);
        AudioMonitoring.CreateSession(ajaxController);
    }
});

$(window).on('beforeunload', function () {
    //
    // Arrete du monitoring audio au dechargement de la page... 
    //
    AudioMonitoring.StopMonitoring();
});


function getSelectedNodes() {
    var selectedNodes = "";
    var nodes = $("li.node.highlighted", projects.treeview);

    $("li.node.highlighted", this.treeview).each(function () {
        var ids = $(this).attr("data-nodekey").split('_');
        var lastId = ids[ids.length - 1];

        selectedNodes += lastId + ",";
    });

    return selectedNodes.replace(/.$/g, ''); // removing last ',' character.
}

function setDialogResources() {
    if (DialogResources == undefined || DialogResources.m_Resources.count < 1) {
        return;
    }

    DialogResources.Set("ira.dialog", { callback: DialogResources.iraremoteagentdialog, message: [resources.PH_IRANotice, resources.PH_IRAPleaseCall, resources.PH_SUPBeep] });
    DialogResources.Set("ora.dialog", { callback: DialogResources.oraremoteagentdialog, message: [resources.PH_ORANotice, resources.PH_ConfirmORA] });
    DialogResources.Set("stationadaptorwronglocation.dialog", { callback: DialogResources.general, message: [resources.PH_LocalStationWrongLocation] });
    DialogResources.Set("station-adaptor-wrong-location", { callback: DialogResources.general, message: [resources.PH_LocalStationWrongLocation] });
    DialogResources.Set("ora.dialog.noauthentication", { callback: DialogResources.remoteagentdialog, message: [resources.PH_ORANotice, resources.PH_ConfirmORA, ""] });
    DialogResources.Set("relogin.dialog", { callback: DialogResources.relogindialog, message: [resources.PH_SUPReloginPart1, resources.PH_SUPReloginPart2] });
    DialogResources.Set("INVALID-AGENT-ID", { callback: DialogResources.general, message: [resources.PH_SUPInvalidAgentId, resources.PH_Reason] });
    DialogResources.Set("PROJECT-DENIED", { callback: DialogResources.general, message: [resources.PH_SUPProjectDenied, resources.PH_Reason] });

    DialogResources.Set("CANNOT-LOGIN-PROJECT", { callback: DialogResources.general, message: [resources.PH_CannotLoginProject, resources.PH_Reason] });
    DialogResources.Set("AGENT-NOT-ONLINE", { callback: DialogResources.notsignedon, message: [resources.PH_AgentNotOnline] });

    DialogResources.Set("WRONG-PARAMTERS", { callback: DialogResources.general, message: [resources.PH_SUPInternalError, resources.PH_Reason] });
    DialogResources.Set("http.error", { callback: DialogResources.httperror, message: [resources.PH_HttpError, resources.PH_Reason] });
    DialogResources.Set("SOCKET.DISCONNECTED", { callback: DialogResources.socketdisconnect, message: [resources.PH_TCPServerDownPart1, resources.PH_TCPServerDownPart2, resources.PH_Reason] });
    DialogResources.Set("socket.request.timeout", { callback: DialogResources.requesttimeout, message: [resources.PH_SUPrequestTimeoutPart1, resources.PH_SUPrequestTimeoutPart2, resources.PH_SUPrequestTimeoutPart3] });
    DialogResources.Set("NOT-SUPERVISOR-AGENT", { callback: DialogResources.general, message: [resources.PH_SUPNotASuppervisor, resources.PH_Reason] });
    DialogResources.Set("SUPERVISOR-PROJECT-NOT-FOUND", { callback: DialogResources.general, message: [resources.PH_SUPSupervisorProjectNotFound, resources.PH_Reason] });
    DialogResources.Set("EXTENSION-WRONG", { callback: DialogResources.general, message: [resources.PH_SUPExtensionWrong, resources.PH_Reason] });
    DialogResources.Set("COMMAND-UNKNOWN", { callback: DialogResources.general, message: [resources.PH_SUPAcessDenied, resources.PH_Reason] });
    DialogResources.Set("NOT-SUPPORTED-IN-ADVANCE-MODE", { callback: DialogResources.commandnotsupported, message: [resources.Command, resources.PH_SUPCommandNotSupported] });
    DialogResources.Set("NO-CONFERENCE-RESOURCES", { callback: DialogResources.general, message: [resources.PH_NoConferenceResource, resources.PH_Reason] });

    DialogResources.Set("CONF-ALREADY-WHISPER", { callback: DialogResources.general, message: [resources.PH_ConferenceAlreadyWhisper, resources.PH_Reason] });
    DialogResources.Set("CONF-ALREADY-JOIN", { callback: DialogResources.general, message: [resources.PH_ConferenceAlreadyJoin, resources.PH_Reason] });
    DialogResources.Set("CONF-MODE-UNKNOWN", { callback: DialogResources.general, message: [resources.PH_ConferenceModeUnknown, resources.PH_Reason] });
    DialogResources.Set("CONF-PLAY-CONFLICT", { callback: DialogResources.general, message: [resources.PH_ConferencePlayConflict, resources.PH_Reason] });


    DialogResources.Set("waiting.ora.authentication.noaccesscode", { callback: DialogResources.waitingORAAuthenticate, message: [resources.PH_SUPORAWaiting, resources.PH_SUPValidateAccessCodeOrPIN] });
    DialogResources.Set("waiting.ora.authentication.accesscode", { callback: DialogResources.waitingORAAuthenticateAccessCode, message: [resources.PH_SUPORAWaiting, resources.PH_SUPValidateAccessCodeOrPIN, resources.PH_SUPValidatePIN] });
    DialogResources.Set("waiting.ora.noauthentication.accesscode", { callback: DialogResources.waitingORAAccessCode, message: [resources.PH_SUPORAWaiting, resources.PH_SUPValidateAccessCodeOrPIN] });
    DialogResources.Set("waiting.ora.noauthentication.noaccesscode", { callback: DialogResources.waitingORA, message: [resources.PH_SUPORAWaiting] });
    DialogResources.Set("waiting.ira.accesscode", { callback: DialogResources.waitingIRAAccessCode, message: [resources.PH_SUPIraWaiting, resources.PH_SUPValidateAccessCodeOrPIN, resources.PH_SUPValidatePIN] });
    DialogResources.Set("waiting.ira.noaccesscode", { callback: DialogResources.waitingIRA, message: [resources.PH_SUPIraWaiting, resources.PH_SUPValidateAccessCodeOrPIN] });

    DialogResources.Set("AGENT.NOT.REGISTER", { callback: DialogResources.general, message: [resources.PH_SUPNotRegistered] });
    DialogResources.Set("AGENT-NOT-SIGNED-ON", { callback: DialogResources.general, message: [resources.PH_SUPSupervisorNotSignon] });
    DialogResources.Set("DIALER-DOWN", { callback: DialogResources.general, message: [resources.PH_SUPProntoDialerNotAvailable] });
    DialogResources.Set("PRONTOSERVER-UNREACHABLE", { callback: DialogResources.general, message: [resources.PH_SUPProntoDialerNotAvailable] });
    DialogResources.Set("PRONTOSERVER-SESSION-ENDED", { callback: DialogResources.general, message: [resources.PH_SUPProntoDialerNotAvailable] });
    DialogResources.Set("CANNOT-LOGIN-PROJECT", { callback: DialogResources.general, message: [resources.PH_SUPProntoDialerNotAvailable] });
    DialogResources.Set("NO-REMOTE-PHONE-NUMBER", { callback: DialogResources.general, message: [resources.PH_SUPNoRemotePhoneNumber] });
    DialogResources.Set("MONITORING-STOP-DENIED", { callback: DialogResources.general, message: [resources.PH_MonitoringStopDenied] });
    DialogResources.Set("PROJECT_WRONG", { callback: DialogResources.general, message: [resources.PH_SUPProjectWrong] });
    DialogResources.Set("NO-SERVER-FOUND", { callback: DialogResources.general, message: [resources.PH_NoServerFound] });
}